#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
# local imports
from neohost_dumps import NeohostDumps
import neohost_sdk_constants as NC


class GetSystemDump(NeohostDumps):
    """
    This class to get device system dump
    """

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(GetSystemDump, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_GET_SYSTEM_DUMP


if __name__ == "__main__":
    rc = GetSystemDump.main()
    sys.exit(rc)
