#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import os
import time
import signal
import json
# local imports
from print_data import PrintData
from abc import ABCMeta, abstractmethod


#################
# class ABEServer
#################
class NBEServer(object):
    """
    Server Class to communicate with Adminic process
    """

    def __init__(self, toolPath):
        """
        Initialize the process
        """
        self._toolPath = toolPath
        self._process = None
        self._jsonDict = None
        self._output = ""
        self._printObj = PrintData()

    def start(self):
        """
        Initialize communication for Adminic Process
        """
        pass

    def postRequest(self, jsonDictRequest):
        """
        To post a request to Adminic
        """
        self._jsonDict = jsonDictRequest
        self.toJSON()

    def getResponse(self, delimiter='\n', timeOut=500):
        """
        Returns A tuple of (output, rc) for the response
        """
        pass

    @abstractmethod
    def stop(self, process, bin_toKill=[]):
        """
        Should implment stop function
        """
        pass

    def toJSON(self):
        """
        Convert a given data to JSON Format
        """
        self._printObj.printOutput("-D- Converting %s  to JSON Format... " % self._jsonDict)
        self._jsonDict = json.dumps(self._jsonDict)
