#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class NeohostConfig(CommandSdk):
    """
    This common class to be inherited  for neohost config
    """

    def __init__(self, timeout=500):
        """
        Constructor for NeohostConfig
        """
        super(NeohostConfig, self).__init__(timeout=timeout)

    def addOptions(self):
        """
        add options
        """
        super(NeohostConfig, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(NeohostConfig, self).parseOptions()
        self.__devUid = self._options.devUid

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(NeohostConfig, self).prepareRequest()
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_CONFIG
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DEV_UID: self.__devUid}

    def validateOptions(self):
        """
        Validate Options
        """
        super(NeohostConfig, self).validateOptions()
        if self.__devUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)
