#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
import os
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class NeohostDumps(CommandSdk):
    """
    This common class to be inherited  for neohost dumps
    """

    def __init__(self, timeout=500):
        """
        Constructor for NeohostDumps
        """
        super(NeohostDumps, self).__init__(timeout=timeout)

    def addOptions(self):
        """
        add options
        """
        super(NeohostDumps, self).addOptions()
        self._cmdParser.add_option("--dump-dir-path", dest="dumpDirPath",
                                   help=NC.HELP_DUMP_DIR_PATH,
                                   default=None)
        self._cmdParser.add_option("--create-dir", dest="createDir",
                                   help=NC.HELP_CREATE_DIR,
                                   action="store_true",
                                   default=True)

    def parseOptions(self):
        """
        parse options
        """
        super(NeohostDumps, self).parseOptions()
        self.__dumpDirPath = self._options.dumpDirPath
        self.__createDir = self._options.createDir

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(NeohostDumps, self).prepareRequest()
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_DEBUG
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DUMP_DIR_PATH: self.__dumpDirPath}

    def validateOptions(self):
        """
        Validate Options
        """
        super(NeohostDumps, self).validateOptions()
        if not self.__dumpDirPath:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DUMP_DIR_PATH)
        if self.__createDir:
            self.createDumpDir(self.__dumpDirPath)

    def createDumpDir(self, dir_name):
        try:
            if not os.path.exists(dir_name):
                os.makedirs(dir_name)
        except OSError:
            raise NeohostSdkException("Failed to create directory: %s" % dir_name)