#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class NeohostPorts(CommandSdk):
    """
    This class to get information which depend on device port
    """

    def addOptions(self):
        """
        add options
        """
        super(NeohostPorts, self).addOptions()
        self._cmdParser.add_option("--port-uid", dest="portUid",
                                  help=NC.HELP_PORT_UID,
                                  default=None)
        self._cmdParser.add_option("--attr-mask", dest="attrMask",
                                  help=NC.HELP_ATTR_MASK,
                                  type="int",
                                  default=0)

    def parseOptions(self):
        """
        parse options
        """
        super(NeohostPorts, self).parseOptions()
        self.__portUid = self._options.portUid
        self.__attrMask = int(self._options.attrMask)

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(NeohostPorts, self).prepareRequest()
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_PORT_UID: self.__portUid,
                                        NC.PARAM_ATTR_MASK: self.__attrMask}

    def validateOptions(self):
        """
        Validate Options
        """
        super(NeohostPorts, self).validateOptions()
        if self.__portUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_PORT_UID)