#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

NEOHOST_COMMAND = "neohost"
VAL_API_VER = "v1"

# RC
RC_FAIL = 1
RC_SUCCESS = 0

# Execution modes
SYNCHRONOUS = 1
A_SYNCHRONOUS = 2

# Running modes
SOCKET_MODE = "socket"
SHELL_MODE = "shell"
NEOHOST_MODES = [SOCKET_MODE, SHELL_MODE]

# Execution modes
STR_SYNC = "sync"
STR_A_SYNC = "a-sync"
NEOHOST_EXEC_MODES = [STR_SYNC, STR_A_SYNC]

# Start line and num of lines for get_application_file_data
START_LINE = 0
NUM_OF_LINES = 1000

# Dump modes
FAST_MODE = "fast"
NORMAL_MODE = "normal"
FULL_MODE = "full"
NEOHOST_DUMP_MODES = {
                      FAST_MODE:     1,
                      NORMAL_MODE:   2,
                      FULL_MODE:     3
                      }

# Methods # add prefix METHOD before methods name . the same for attr and modules
METHOD_GET_PORT_INFO = "GetPortInfo"
METHOD_GET_DEVICE_VPD = "GetDeviceVPD"
METHOD_SET_DEVICE_ROCE = "SetDeviceRoCE"
METHOD_SET_ROCE_CLEANUP = "SetDeviceRoCECleanup"
METHOD_GET_DEVICE_ROCE_STATE = "GetDeviceRoCEState"
METHOD_GET_ROCE_VALIDATION = "GetDeviceRoCEValidation"
METHOD_GET_SYSTEM_INFO = "GetSystemServerInfo"
METHOD_GET_SYSTEM_DUMP = "DebugGetSystemInfo"
METHOD_SET_DEVICE_RESET = "SetDeviceReset"
METHOD_SET_DEVICE_SRIOV = "SetDeviceSRIOV"
METHOD_GET_DEVICE_SRIOV_STATE = "GetDeviceSRIOVState"
METHOD_GET_DEVICE_UP_TIME = "GetDeviceUpTime"
METHOD_GET_INTERFACE_INFO = "GetInterfaceInfo"
METHOD_GET_DEVICE_CR_DUMP = "DebugGetDeviceCrDump"
METHOD_GET_APP_JOB_STATUS = "GetApplicationJobStatus"
METHOD_GET_SYSTEM_DEVICES = "GetSystemDevices"
METHOD_GET_PORT_CABLE_INFO = "GetPortCableInfo"
METHOD_SET_DEVICE_FW_UPDATE = "SetDeviceFwUpdate"
METHOD_GET_DEVICE_NV_CONFIG = "GetDeviceNVConfig"
METHOD_SET_DEVICE_NV_CONFIG = "SetDeviceNVConfig"
METHOD_GET_DEVICE_FLASH_INFO = "GetDeviceFlashInfo"
METHOD_GET_DEVICE_FLASH_DUMP = "DebugGetDeviceFlashDump"
METHOD_GET_DEVICE_TEMPERATURE = "GetDeviceTemperature"
METHOD_GET_DEVICE_RESET_LEVEL = "GetDeviceResetLevel"
METHOD_GET_DEVICE_FW_IMAGE_INFO = "GetDeviceFwImageInfo"
METHOD_GET_APPLICATION_FILE_DATA = "GetApplicationFileData"
METHOD_GET_DEVICE_THERMAL_THRESHOLDS = "GetDeviceThermalThresholds"
METHOD_SET_DEVICE_NV_CONFIG_DEFAULTS = "SetDeviceNVConfigDefaults"
METHOD_GET_DEVICE_NV_CONFIG_META_DATA = "GetDeviceNVConfigMetaData"
METHOD_GET_APPLICATION_FILE_META_DATA = "GetApplicationFileMetaData"
METHOD_GET_DEVICE_PERFORMANCE_COUNTERS = "GetDevicePerformanceCounters"

# Modules
MODULE_CORE = "core"
MODULE_MFT_FW = "mftFw"
MODULE_MFT_CORE = "mftCore"
MODULE_MFT_DEBUG = "mftDebug"
MODULE_MFT_CABLES = "mftCables"
MODULE_MFT_CONFIG = "mftConfig"
MODULE_CONFIG_FLOWS = "configFlows"
MODULE_PERFORMANCE = "performance"

# Attributes
ATTR_ID = "id"
ATTR_PARAMS = "params"
ATTR_METHOD = "method"
ATTR_MODULE = "module"
ATTR_API_VER = "apiVer"
ATTR_EXEC_MODE = "execMode"

# Params
PARAM_LEVEL = "level"
PARAM_FORCE = "force"
PARAM_DEV_UID = "devUid"
PARAM_DEV_PSID = "psid"
PARAM_IFC_UID = "ifcUid"
PARAM_NUM_VFS = "numVFs"
PARAM_PORT_UID = "portUid"
PARAM_UPDATE_FW = "updateFw"
PARAM_ATTR_MASK = "attrMask"
PARAM_JOB_TOKEN = "jobToken"
PARAM_DSCP_ROCE = "dscpVal"
PARAM_FILE_TYPE = "fileType"
PARAM_FILE_PATH = "filePath"
PARAM_DUMP_COUNT = "dumpCount"
PARAM_DUMP_MODE = "runMode"
PARAM_START_LINE = "startLine"
PARAM_PARAMS_LIST = "paramsList"
PARAM_CONFIG_MODE = "configMode"
PARAM_CONFIG_NAME = "configName"
PARAM_NUM_OF_LINES = "numOfLines"
PARAM_DUMP_DIR_PATH = "dumpDir"
PARAM_CREATE_DIR = "createDir"
PARAM_CONFIG_TYPE = "configType"
PARAM_NUM_VFS_CONFIG = "numVFsConfig"
PARAM_CONFIG_MODIFIER = "configModifier"
PARAM_ACCESS_DATA_MODIFIER = "accessDataMod"
PARAM_SUPPORTED_PARAMS_ONLY = "supportedParamsOnly"
PARAM_RECORD_PATH = "recordPath"
PARAM_GET_ANALYSIS = "getAnalysis"

# HELP Messages
HELP_PID = "Process ID for a running neohost"
HELP_DEV_UID = "Device uid to get Information for"
HELP_DEV_PSID = "Device PSID to get Information for"
HELP_PORT_UID = "Port uid to get Information for."
HELP_ATTR_MASK = "Attr Mask Bit0 shows Description, Bit1 shows index. [Provide it as integer]"
HELP_FILE_PATH = "The path for the image."
HELP_JOB_TOKEN = "Job token Id for an a_sync command"
HELP_DSCP_ROCE = "Advanced Parameter in RoCE, default is 26"
HELP_FORCE_ROCE = "Force setDeviceRoCE"
HELP_FILE_TYPE = "File type data. Now we just support file type 1 which means text "
HELP_START_LINE = "The start line to read from the log."
HELP_DUMP_COUNT = "Number of dumps for DebugGetDeviceCrDump between [1, 5]"
HELP_CR_DUMP_RUN_MODE = "Choose crDump mode, from [fast, normal, full], default 'fast'"
HELP_RESET_LEVEL = "A device reset level."
HELP_SOCKET_PORT = "Running port for neohost socket"
HELP_CONFIG_TYPE = "config Type for Without Qos=1 / With Qos=2 / Lossless with Qos=3, , Default value 1"
HELP_CONFIG_MODE = "Configuration mode {'next': 1, 'current': 2, 'default': 3} the default is next"
HELP_CONFIG_NAME = "Configuration name: if not preset, all configuration will be retrieved"
HELP_KILL_NEOHOST = "This option to kill running neohost"
HELP_INTERFACE_UID = "interface uid to get Information for."
HELP_CONFIG_PARAMS = "Configuration Params in this structure 'param1Name=param1Val,param2Name=param2Val ...'"
HELP_DUMP_DIR_PATH = "A dump file dir to save dumps file there."
HELP_CREATE_DIR = "Create dump dir if not exist, Type[bool]"
HELP_VFS_NUM_CONFIG = "Number of virtual functions configurations . --vfs-num-conf 'ifcUid=interfaceUid1,numVFs=virtual functions number;\
'ifcUid=interfaceUid2,numVFs=virtual functions number; ..."
HELP_CONFIG_MODIFIER = "Configuration modifier - port name in port configurations"
HELP_NUMBER_OF_LINES = "Number of lines to read from log file."
HELP_ENABLE_UPDATE_FW = "Enable update of FW value for SRIOV. Type[bool]"
HELP_SUPPORTED_PARAMS_ONLY = "Show only supported parameters for the device. Type [bool], default value [False]"
HELP_READABLE_PERFORMANCE_COUNTERS = "Show performance counters in readable manner, Default value [False]"
HELP_DESCRIPTION_PERFORMANCE_COUNTERS = ("Show performance counters description on "
                                         "--output-format=readable or --replay-path or --record-path options,"
                                         " Default value [False]")
HELP_UNITS_PERFORMANCE_COUNTERS = ("Show grouping of the counters by the units in the chip, Default value [False]")
HELP_COUNTINUES_RUN_PERFORMANCE_COUNTERS = ("Run sampling in a loop until Ctrl+c pressed, Default value [False]")
HELP_RECORD_RUN_PERFORMANCE_COUNTERS = "Record live session with the full file path given, until Ctrl+c pressed"
HELP_REPLAY_RUN_PERFORMANCE_COUNTERS = "Replay recorded live session with the full file path given, until Ctrl+c pressed"
HELP_DELAY_RUN_PERFORMANCE_COUNTERS = "The refresh rate in seconds of the --replay-path option, Default value [1]"
HELP_JSON_PERFORMANCE_COUNTERS = "Get JSON of the performance counters results, Default value [False]"
HELP_GET_ANALYSIS = "Get performane analysis inforamation, Default value [False]"

MISSING_OPTION = "Missing option:"
MISSING_LEVEL = "%s --level" % MISSING_OPTION
MISSING_DEV_UID = "%s --dev-uid." % MISSING_OPTION
MISSING_IFC_UID = "%s --interface-uid." % MISSING_OPTION
MISSING_JOB_TOKEN = "%s --job-token-id." % MISSING_OPTION
MISSING_FILE_TYPE = "%s --file-type." % MISSING_OPTION
MISSING_PORT_UID = "%s --port-uid." % MISSING_OPTION
MISSING_FILE_PATH = "%s --file-path." % MISSING_OPTION
MISSING_START_LINE = "%s --start-line" % MISSING_OPTION
MISSING_PORT_SOCKET = "%s --port." % MISSING_OPTION
MISSING_NUM_OF_LINES = "%s --num-of-lines" % MISSING_OPTION
MISSING_VFS_NUM_CONFIG = "%s --vfs-num-config. %s" % (MISSING_OPTION, HELP_VFS_NUM_CONFIG)
UNSUPPORTED_EXEC_MODE = "Un Supported Execution mode: a_sync is not supported for"
MISSING_CONFIG_PARAMS = "%s --config-params. %s" % (MISSING_OPTION, HELP_CONFIG_PARAMS)
MISSING_DUMP_DIR_PATH = "%s --dump-dir-path" % MISSING_OPTION
MISSING_READABLE_FLAG = "%s --readable" % MISSING_OPTION
WRONG_PARAMETERS_CHOOSE_SHOW_COUNTERS = "%s should not be used with %s"
PARAMETERS_CHOOSE_SHOW_COUNTERS = "%s should be used with %s option(s)"
PARAMETERS_CHOOSE_AVAILABLE = "%s is available with %s option(s)"
MISSING_CHOSEN_OPTION = "Please choose option from the help screen."
WRONG_PARAMETER_CHOICE_MFA = "PSID or UID for the device should be given only for MFA Images"
MISSING_PARAMETER_CHOICE_MFA = "%s --dev-uid or --dev-psid for the device\
should be given for MFA Images" % MISSING_OPTION


# Performance commands examples:
PERFORMANCE_USAGE_EXAMPLES = \
    "1. get_device_performance_counters.py --dev-uid=0000:06:00.0 --output-format=JSON{0:>70}".format('') + \
    "2. get_device_performance_counters.py --dev-uid=0000:06:00.0 {0:>70}".format('') + \
    "3. get_device_performance_counters.py --dev-uid=0000:06:00.0 --get-analysis{0:>70}".format('') + \
    "4. get_device_performance_counters.py --dev-uid=0000:06:00.0 --get-analysis --run-loop{0:>70}".format('') + \
    "5. get_device_performance_counters.py --dev-uid=0000:06:00.0 --show-description --run-loop{0:>70}".format('') + \
    "6. get_device_performance_counters.py --dev-uid=0000:06:00.0 --show-unit-counters{0:>70}".format('') + \
    "7. get_device_performance_counters.py --dev-uid=0000:06:00.0 --record-path=/tmp/record_file{0:>70}".format('') + \
    "8. get_device_performance_counters.py --replay-path=/tmp/record_file --delay=2{0:>70}".format('')


class OutputFormatOptions(object):
    """ Represents command line output format options ENUM.
    """
    JSON = "JSON"
    READABLE = "readable"
