#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import os
import time
import sys
from subprocess import Popen, PIPE, STDOUT
# local imports
from neohost_backend_server import NBEServer
from neohost_sdk_exception import NeohostSdkException


class NBEShellServer(NBEServer):
    """
    This class is for Neohost backend stdin/stdout process server
    """

    def __init__(self, toolPath):
        """
        :param toolPath:
        """
        self.__toolPath = toolPath
        self._process = None
        super(NBEShellServer, self).__init__(self.__toolPath)

    def start(self, process=None):
        """
        Start shell server
        """
        self._printObj.printOutput("-D- Initialize Server for a streaming stdin/stdout process %s..." % self._toolPath)
        self._process = process
        if not self._process:
            preexecFn = None
            if "win" not in sys.platform:
                self._process = Popen(self._toolPath, shell=False, stdin=PIPE, stdout=PIPE, stderr=PIPE,
                                        universal_newlines=False, close_fds=True, preexec_fn=os.setpgrp)
            else:
                self._process = Popen(self._toolPath, shell=True, stdin=PIPE, stdout=PIPE, stderr=PIPE)
        return self._process

    def postRequest(self, jsonReq, clientObj=None):
        """
        Post request to shell
        """
        if clientObj == None:
            clientObj = self._process
        super(NBEShellServer, self).postRequest(jsonReq)
        clientObj.stdin.write(self._jsonDict + os.linesep)

    def getResponse(self, clientObj=None, delimiter='\n', timeOut=500):
        """
        :param delimiter:
        :param timeOut:
        :return:
        """
        if not clientObj:
            clientObj = self._process
        startTime = time.time()
        self._printObj.printOutput("-D- Getting Process Output from a streaming process .... ")
        while True:
            currTime = time.time()
            if currTime - startTime > timeOut:
                raise NeohostSdkException("Timeout when trying to get Neohost response [%s]" % timeOut)
            char = clientObj.stdout.read(1)
            self._output += char
            if char == delimiter:
                break
        return self._output.strip()

    def stop(self, process=None):
        """
        To stop adminic shell server
        :return:
        """
        if not process:
            process = self._process
        super(NBEShellServer, self).stop(process)
        process.stdin.close()

    def createClientObject(self):
        """

        :return:
        """
        process = Popen(self._toolPath, shell=False, stdin=PIPE, stdout=PIPE, stderr=PIPE,
                        universal_newlines=False, close_fds=True)
        return process
