#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import os
import sys
import telnetlib
import subprocess
import shlex
import time
# local imports
from print_data import PrintData

class NBESocketClient(object):
    """
    This class is for AdmiNIC backend socket server
    """

    def __init__(self, socketServerObj, ip="localhost", socketPort=200):
        """
        param toolPath:
        """
        self.__socketPort = socketPort
        self.__socketIP   = ip
        self.__socketServerObj = socketServerObj
        self.__neohostClientObj = None
        self._printObj = PrintData()

    def start(self):
        """
        Starts Adminic backend socket Client server
        :return:
        """
        self._printObj.printOutput("-D- Initialize Client to Neohost backend server using telnet on [%s, %s]" %
                    (self.__socketIP, self.__socketPort))
        self.__neohostClientObj = telnetlib.Telnet()
        self.__neohostClientObj.open(self.__socketIP, self.__socketPort)

    def postRequest(self, jsonReq):
        """
        post request to adminic backend via telnet
        :param jsonReq:
        :return:
        """
        self.__neohostClientObj.write(jsonReq + os.linesep)

    def getResponse(self, delimiter='}\n', timeOut=1):
        """
        Gets the response from AdmiNIC backend telnet
        :param delimiter:
        :param timeOut:
        :return:
        """
        self._printObj.printOutput("-D- Getting AdmiNic Backend output from a socket")
        self._output = self.__neohostClientObj.read_until("}\n", timeout=timeOut)
        if self._output == "":
            raise Exception("Failed to get output from a socket.")
        return self._output.strip()

    def stop(self):
        """
        This is to stop the client server
        :return:
        """
        self._printObj.printOutput("-D- Stop Client connection to telnet [%s, %s]" %
                    (self.__socketIP, self.__socketPort))
        self.__neohostClientObj.close()