#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import os
import sys
import re
import telnetlib
import subprocess
import shlex
import time
# local imports
from neohost_backend_server import NBEServer
from neohost_socket_client import NBESocketClient
from exec_command import Command
from neohost_sdk_exception import NeohostSdkException


class NBESocketServer(NBEServer):
    """
    This class is for AdmiNIC backend socket server
    """

    def __init__(self, toolPath, ip="localhost", socketPort=200, ):
        """
        param toolPath:
        """
        self.__toolPath = "%s -s %s" % (toolPath, socketPort)
        self.__socketPort = socketPort
        self.__socketIP = ip
        self.__neohostClientObj = None
        self.__neohostServerObj = None
        self.__pid = None
        super(NBESocketServer, self).__init__(self.__toolPath)

    def start(self):
        """
        Starts Adminic backend socket server
        :return:
        """
        self._printObj.printOutput("-D- Initialize Server to neohost backend %s on port [%s] ... " %
                                   (self.__toolPath, self.__socketPort))
        self.__neohostServerObj = None
        close_fds = (True, False)["win" in sys.platform]
        with open(os.devnull, 'w') as dev_null:
            self.__neohostServerObj = subprocess.Popen(
                self.__toolPath, stdout=dev_null, stderr=dev_null, shell=True, close_fds=close_fds)
        time.sleep(1)  # sleep for a while to init the server
        return self.__getPID()

    def postRequest(self, jsonReq, clientObj):
        """
        post request to adminic backend via telnet
        :param jsonReq:
        :return:
        """
        super(NBESocketServer, self).postRequest(jsonReq)
        clientObj.postRequest(self._jsonDict)

    def getResponse(self, clientObj, delimiter='}', timeOut=1):
        """
        Gets the response from AdmiNIC backend telnet
        :param delimiter:
        :param timeOut:
        :return:
        """
        super(NBESocketServer, self).getResponse()
        responseObj = clientObj.getResponse(delimiter=delimiter, timeOut=timeOut)
        return responseObj

    def stop(self, pid=None):
        """
        Stops the server for the client, server or both
        :return:
        """
        self._printObj.printOutput("-E- Stop Server and client connection to telnet [%s, %s]" %
                                   (self.__socketIP, self.__socketPort))
        if not pid:
            pid = self.__pid
        killCmd = ("kill 2 %s" % pid, "taskkill /F /PID %s /T" % pid)["win" in sys.platform]
        killCmdObj = Command(killCmd)
        _, out, err = killCmdObj.execute()
        time.sleep(2)
        if err:
            raise NeohostSdkException(err)


    def createClientObject(self, socketIp=None, socketPort=None):
        """
        This is to create and return a client object
        :return:
        """
        if not socketIp:
            socketIp = self.__socketIP
        if not socketPort:
            socketPort = self.__socketPort
        self.__neohostClientObj = NBESocketClient(NBEServer, socketIp, socketPort)
        self.__neohostClientObj.start()
        return self.__neohostClientObj

    def __getPID(self):
        """
        This to get neohost PID [neohost.pyo pid]
        :return:
        """
        cmdObj = Command(("ps -ef | grep neohost.pyo*", 'wmic process get CommandLine, ParentProcessId, ProcessID | grep neo')["win" in sys.platform])
        _, output, stderr = cmdObj.execute()
        if stderr:
            raise NeohostSdkException(stderr)   
        processPtrn = (re.compile(r'\w+\s+(\d+).*neohost.pyo.*%s' % self.__socketPort),
                        re.compile(r'C\:\\Windows\\system32\\cmd\.exe \/c \"neohost \-s %s\"\s+\d+\s+(\d+)' % self.__socketPort))["win" in sys.platform]
        pyoPIDPtrn = processPtrn
        pyoID = pyoPIDPtrn.search(output)
        if not pyoID:
            raise NeohostSdkException("Can`t find process PID fneohost -s %s" % self.__socketPort)
        self.__pid = pyoID.groups()[0]
        return self.__pid
