#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import sys
import optparse
# local imports
from neohost_socket_server import NBESocketServer
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class RunNeohost(object):
    """
    This class to run neohost
    """

    def __init__(self):
        """
        Constructor for RunNeohost
        """
        self.cmdparser = optparse.OptionParser()
        self.addOptions()
        self.parseOptions()
        self.neohostServer = NBESocketServer(NC.NEOHOST_COMMAND, socketPort=self.__port)

    def addOptions(self):
        """
        add option
        """
        self.cmdparser.add_option("--port",
                                  dest="socketPort",
                                  help=NC.HELP_SOCKET_PORT,
                                  default=None)
        self.cmdparser.add_option("--pid",
                                  dest="pid",
                                  help=NC.HELP_PID,
                                  default=None)
        self.cmdparser.add_option("--kill",
                                  dest="killNeohost",
                                  help=NC.HELP_KILL_NEOHOST,
                                  action="store_true",
                                  default=False)

    def parseOptions(self):
        """
        parseOption
        """
        (options, args) = self.cmdparser.parse_args()
        self.__port = options.socketPort
        self.__killNeohost = options.killNeohost
        self.__pid = options.pid
        if not self.__port and not self.__killNeohost:
            raise NeohostSdkException("%s Please Specify a port to run neohost" % NC.MISSING_PORT_SOCKET)
        if self.__killNeohost and not self.__pid:
            raise NeohostSdkException("Missing option: --pid")
        if self.__port and self.__killNeohost:
            raise NeohostSdkException("The two options are not working in the same time.")

    def __runNeohostServer(self):
        """
        Run neohost server
        """
        return self.neohostServer.start()

    def __killProcess(self, pid):
        """
        Stop Neohost
        :return:
        """
        self.neohostServer.stop(pid)

    def runScript(self):
        if self.__killNeohost:
            self.__killProcess(self.__pid)
            print("-I- neohost for a given pid %s was killed successfully" % self.__pid)
        else:
            pid = self.__runNeohostServer()
            print("PID %s" % pid)


def main():
    runNeohostObj = RunNeohost()
    runNeohostObj.runScript()

if __name__ == "__main__":
    rc = NC.RC_SUCCESS
    try:
        main()
    except Exception as e:
        print("-E- %s" % e)
        rc = NC.RC_FAIL
    sys.exit(rc)