#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/April

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class SetDeviceFWUpdate(CommandSdk):
    """
    This class to set device fw update
    """

    def __init__(self):
        """
        Constructor for SetDeviceFWUpdate
        """
        super(SetDeviceFWUpdate, self).__init__()

    def addOptions(self):
        """
        add options
        """
        super(SetDeviceFWUpdate, self).addOptions()
        self._cmdParser.add_option("--dev-uid",
                                   dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)
        self._cmdParser.add_option("--file-path",
                                   dest="filePath",
                                   help=NC.HELP_FILE_PATH,
                                   default=None)
        self._cmdParser.add_option("--force",
                                   dest="forceBurn",
                                   action="store_true",
                                   help="Force burning an image",
                                   default=False)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceFWUpdate, self).parseOptions()
        self.__devUid = self._options.devUid
        self.__filePath = self._options.filePath
        self.__forceBurn = self._options.forceBurn

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceFWUpdate, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_FW_UPDATE
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_FW
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DEV_UID: self.__devUid,
                                     NC.PARAM_FILE_PATH: self.__filePath,
                                     NC.PARAM_FORCE: self.__forceBurn}

    def validateOptions(self):
        """
        Validate Options
        """
        super(SetDeviceFWUpdate, self).validateOptions()
        if self.__devUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)
        if not self.__filePath:
            raise NeohostSdkException("-E- %s.Please specify the image path to be burnt." % NC.MISSING_FILE_PATH)


if __name__ == "__main__":
    rc = SetDeviceFWUpdate.main()
    sys.exit(rc)
