#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from neohost_sdk_exception import NeohostSdkException
from neohost_config import NeohostConfig
import neohost_sdk_constants as NC


class SetDeviceNVConfig(NeohostConfig):
    """
    This class to set device non volatile configuration
    """

    def __init__(self):
        """
        Constructor for SetDeviceNVConfig
        """
        super(SetDeviceNVConfig, self).__init__()
        self.__configParams = None
        self.__paramsList = []

    def addOptions(self):
        """
        add options
        """
        super(SetDeviceNVConfig, self).addOptions()
        self._cmdParser.add_option("--config-params", dest="configParams",
                                   help=NC.HELP_CONFIG_PARAMS,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceNVConfig, self).parseOptions()
        self.__configParams = self._options.configParams

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceNVConfig, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_NV_CONFIG
        self.request[NC.ATTR_PARAMS][NC.PARAM_PARAMS_LIST] = self.__paramsList

    def validateOptions(self):
        """
        Validate Options
        """
        super(SetDeviceNVConfig, self).validateOptions()
        if not self.__configParams:
            raise NeohostSdkException("-E- %s" % NC.MISSING_CONFIG_PARAMS)
        self.__parseConfigParams()

    def __parseConfigParams(self):
        """
        This is to parse Config Params
        :return:
        """
        try:
            paramsObj = self.__configParams.split(",")
            for paramObj in paramsObj:
                parmDict = {}
                paramObj = paramObj.split("=")
                parmDict['paramName'] = paramObj[0]
                parmDict['paramVal'] = paramObj[1]
                self.__paramsList.append(parmDict)
        except Exception as e:
            raise NeohostSdkException("Error %s. %s" % (e, NC.HELP_CONFIG_PARAMS))

if __name__ == "__main__":
    rc = SetDeviceNVConfig.main()
    sys.exit(rc)
