#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/May

# Python Imports
import sys
# local imports
from neohost_sdk_exception import NeohostSdkException
from neohost_config import NeohostConfig
import neohost_sdk_constants as NC


class SetDeviceNVConfigDefaults(NeohostConfig):
    """
    This class to set defaults device non volatile configuration
    """

    def __init__(self):
        """
        Constructor for SetDeviceNVConfigDefaults
        """
        super(SetDeviceNVConfigDefaults, self).__init__()
        self.__configName = None

    def addOptions(self):
        """
        add options
        """
        super(SetDeviceNVConfigDefaults, self).addOptions()
        self._cmdParser.add_option("--config-name", dest="configName",
                                   help=NC.HELP_CONFIG_NAME,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceNVConfigDefaults, self).parseOptions()
        self.__configName = self._options.configName

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceNVConfigDefaults, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_NV_CONFIG_DEFAULTS
        if self.__configName:
            self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_NAME] = self.__configName


if __name__ == "__main__":
    rc = SetDeviceNVConfigDefaults.main()
    sys.exit(rc)
