#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2013, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/March

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class SetDeviceReset(CommandSdk):
    """
    This class to get device flash info
    """

    def __init__(self):
        """
        Constructor for SetDeviceReset
        """
        super(SetDeviceReset, self).__init__()

    def addOptions(self):
        """
        add options
        """
        super(SetDeviceReset, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)
        self._cmdParser.add_option("--level", dest="level",
                                   help=NC.HELP_RESET_LEVEL,
                                   default=0)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceReset, self).parseOptions()
        self.__devUid = self._options.devUid
        self.__level = self._options.level

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceReset, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_RESET
        self.request[NC.ATTR_MODULE] = NC.MODULE_MFT_FW
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DEV_UID: self.__devUid,
                                        NC.PARAM_LEVEL: int(self.__level)}

    def validateOptions(self):
        """
        Validate Options
        """
        super(SetDeviceReset, self).validateOptions()
        if self.__devUid == None:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)
        if self.__level == 0:
            raise NeohostSdkException("-E- %s" % NC.MISSING_LEVEL)


if __name__ == "__main__":
    rc = SetDeviceReset.main()
    sys.exit(rc)
