#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Weam Mikkawi   weammik@mellanox.com -- created: 2018/Jan

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class SetDeviceRoCE(CommandSdk):
    """
    This class to set device RoCE
    """

    def __init__(self):
        """
        Constructor for SetDeviceRoCE
        """
        super(SetDeviceRoCE, self).__init__()
        self.__devUid = None
        self.__interfaceUid = None
        self.__configType = None
        self.__dscpVal = None
        self.__forceROCE = None


    def addOptions(self):
        """
        add options
        """
        super(SetDeviceRoCE, self).addOptions()
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)
        self._cmdParser.add_option("--interface-uid", dest="interfaceUid",
                                   help=NC.HELP_INTERFACE_UID,
                                   default=None)
        self._cmdParser.add_option("--config-type", dest="configType",
                                   help=NC.HELP_CONFIG_TYPE,
                                   type="int",
                                   default=1)
        self._cmdParser.add_option("--dscp", dest="dscpVal",
                                    help=NC.HELP_DSCP_ROCE,
                                    type=int)
        self._cmdParser.add_option("--force",
                                   dest="forceROCE",
                                   action="store_true",
                                   help=NC.HELP_FORCE_ROCE,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceRoCE, self).parseOptions()
        self.__devUid = self._options.devUid
        self.__interfaceUid = self._options.interfaceUid
        self.__configType = int(self._options.configType)
        if self._options.dscpVal:
            self.__dscpVal = int(self._options.dscpVal)
        self.__forceROCE = self._options.forceROCE

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceRoCE, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_ROCE
        self.request[NC.ATTR_MODULE] = NC.MODULE_CONFIG_FLOWS
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_IFC_UID: self.__interfaceUid,
                                        NC.PARAM_CONFIG_TYPE: self.__configType}
        if self.__devUid:
            self.request[NC.ATTR_PARAMS][NC.PARAM_DEV_UID] = self.__devUid
        paramConfigModifierDict = {}
        if self.__dscpVal:
            paramConfigModifierDict[NC.PARAM_DSCP_ROCE] = self.__dscpVal
        if self.__forceROCE:
            paramConfigModifierDict[NC.PARAM_FORCE] = self.__forceROCE
        if paramConfigModifierDict:
            self.request[NC.ATTR_PARAMS][NC.PARAM_CONFIG_MODIFIER] = paramConfigModifierDict


    def validateOptions(self):
        """
        Validate Options
        """
        super(SetDeviceRoCE, self).validateOptions()
        if not self.__interfaceUid:
            raise NeohostSdkException("-E- %s" % NC.MISSING_IFC_UID)

if __name__ == "__main__":
    rc = SetDeviceRoCE.main()
    sys.exit(rc)
