#!/usr/bin/env python

# --
#                 - Mellanox Confidential and Proprietary -
#
# Copyright (C) Jan 2017, Mellanox Technologies Ltd.  ALL RIGHTS RESERVED.
#
# Except as specifically permitted herein, no portion of the information,
# including but not limited to object code and source code, may be reproduced,
# modified, distributed, republished or otherwise exploited in any form or by
# any means for any purpose without the prior written permission of Mellanox
# Technologies Ltd. Use of software subject to the terms and conditions
# detailed in the file "LICENSE.txt".
# --
# Author: Ahmed Awwad   ahmadaw@mellanox.com -- created: 2017/June

# Python Imports
import sys
# local imports
from command_sdk import CommandSdk
import neohost_sdk_constants as NC
from neohost_sdk_exception import NeohostSdkException


class SetDeviceSRIOV(CommandSdk):
    """
    This class to set device sriov
    """

    def __init__(self):
        """
        Constructor for SetDeviceSRIOV
        """
        super(SetDeviceSRIOV, self).__init__()
        self.__devUid = None
        self.__updateFw = None
        self.__interfaceUid = None
        self.__VFsNumConfig = None
        self.__VFsNumConfigList = []

    def addOptions(self):
        """
        add options
        """
        super(SetDeviceSRIOV, self).addOptions()
        self._cmdParser.add_option("--vfs-num-config", dest="vfsNumConfig",
                                   help=NC.HELP_VFS_NUM_CONFIG,
                                   default=None)
        self._cmdParser.add_option("--enable-update-fw", dest="updateFw",
                                   help=NC.HELP_ENABLE_UPDATE_FW,
                                   action="store_true",
                                   default=None)
        self._cmdParser.add_option("--dev-uid", dest="devUid",
                                   help=NC.HELP_DEV_UID,
                                   default=None)

    def parseOptions(self):
        """
        parse options
        """
        super(SetDeviceSRIOV, self).parseOptions()
        self.__VFsNumConfig = self._options.vfsNumConfig
        self.__devUid = self._options.devUid
        self.__updateFw = self._options.updateFw

    def prepareRequest(self):
        """
        Prepare request before post it . add method and module.
        """
        super(SetDeviceSRIOV, self).prepareRequest()
        self.request[NC.ATTR_METHOD] = NC.METHOD_SET_DEVICE_SRIOV
        self.request[NC.ATTR_MODULE] = NC.MODULE_CONFIG_FLOWS
        self.request[NC.ATTR_PARAMS] = {NC.PARAM_DEV_UID: self.__devUid,
                                        NC.PARAM_NUM_VFS_CONFIG: self.__VFsNumConfigList}
        if self.__updateFw != None:
            self.request[NC.ATTR_PARAMS][NC.PARAM_UPDATE_FW] = self.__updateFw

    def validateOptions(self):
        """
        Validate Options
        """
        super(SetDeviceSRIOV, self).validateOptions()
        if not self.__VFsNumConfig:
            raise NeohostSdkException("-E- %s" % NC.MISSING_VFS_NUM_CONFIG)
        if not self.__devUid:
            raise NeohostSdkException("-E- %s" % NC.MISSING_DEV_UID)
        self.__parseNumVFsConfig()

    def __parseNumVFsConfig(self):
        """
        This is to parse numVfsConfig param
        :return:
        """
        try:
            paramsObj = self.__VFsNumConfig.split(";")
            for paramObj in paramsObj:
                paramObj = paramObj.split(',')
                numVfsConfDict = {NC.PARAM_IFC_UID: paramObj[0].split('=')[1],
                                  NC.PARAM_NUM_VFS: int(paramObj[1].split('=')[1])}
                self.__VFsNumConfigList.append(numVfsConfDict)
        except Exception as e:
            raise NeohostSdkException("%s.%s" % (e, NC.HELP_VFS_NUM_CONFIG))


if __name__ == "__main__":
    rc = SetDeviceSRIOV.main()
    sys.exit(rc)
