/*
 * Copyright (c) 2013 Mellanox Technologies LTD. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/*
 * Abstract:
 *	Declaration of crc functios that calculate crc for
 *	a given buffer.
 */
#ifndef _CL_CRC_H_
#define _CL_CRC_H_

#include <stdio.h>
#include <complib/cl_types.h>

#ifdef __cplusplus
#  define BEGIN_C_DECLS extern "C" {
#  define END_C_DECLS   }
#else				/* !__cplusplus */
#  define BEGIN_C_DECLS
#  define END_C_DECLS
#endif				/* __cplusplus */

BEGIN_C_DECLS

#define CRC32_POLYNOMIAL   0xEDB88320L
/****f* IBA Base: Types/cl_calc_crc32
 * NAME
 *	cl_calc_crc32
 *
 * DESCRIPTION
 *	calculate crc32 for a given buffer and a given crc value.
 *
 * SYNOPSIS
 *
 */
uint32_t cl_calc_crc32(IN void *buffer, IN uint32_t count, IN uint32_t crc32);
/*
 * PARAMETERS
 *	buffer
 *		[in] buffer for crc calculation.
 *	count
 *		[in] size of the buffer.
 *	crc32
 *		[in] accumulate crc for continuous calculation.
 *
 * RETURN VALUES
 *	crc32 for the given buffer.
 *
 * NOTES
 *
 * SEE ALSO
 * *********/
END_C_DECLS
#endif			/* _CL_CRC_H_ */
