#!/bin/csh
# Copyright (c) 2007 Cisco Systems, Inc.  All rights reserved.
#
# File installed for Bourne-shell startups to select which MPI
# installation to use.  Not using "alternatives" because we want to be
# able to set per-user level defaults, not just system-wide defaults.

set mpi_selector_dir="/var/mpi-selector/data"
set mpi_selector_homefile="$HOME/.mpi-selector"
set mpi_selector_sysfile="/etc/sysconfig/mpi-selector"

set mpi_selection=
if (-f "$mpi_selector_homefile") then
    set mpi_selection=`cat $mpi_selector_homefile`
else if (-f "$mpi_selector_sysfile") then
    set mpi_selection=`cat $mpi_selector_sysfile`
endif

if ("$mpi_selection" != "" && -f "$mpi_selector_dir/$mpi_selection.csh") then
    source "$mpi_selector_dir/$mpi_selection.csh"
endif
