
import platform
import sys
# autopep8: off
TOOL_MIN_PYTHON_VERSION = (3, 4, 0)
py_major, py_minor = [int(e) for e in platform.python_version_tuple()[:2]]
min_py_major, min_py_minor, _ = TOOL_MIN_PYTHON_VERSION
if py_major < min_py_major or py_minor < min_py_minor:
    sys.exit("Error: this tool requires python version >= {}".format('.'.join([str(a) for a in TOOL_MIN_PYTHON_VERSION])))
# autopep8: on
import logging
from modes.mlxburn_BurnMode import BurnMode
from cli_wrapping_utils import *
from mlxburn_constants import *
from mlxburn_argumentParser import MlxBurn_ArgumentParser
from modes.mlxburn_mode import I_MlxburnMode
from modes.mlxburn_ImageGenerateMode import ImageGenerateMode
from modes.mlxburn_QueryMode import QueryMode
from modes.mlxburn_ShowVpdMode import ShowVpdMode
from modes.mlxburn_ViewVersionMode import ViewVersionMode


def init_logging(args):
    logging.basicConfig(style="{", format="-{levelname[0]}- {message}", level=logging.getLevelName(args.verbosity), stream=sys.stdout)
    logging.debug("Passed arguments:\n{}".format((str(args))))


MAIN_MODE_OBJECTS = {
    MAIN_MODE.SHOW_FW_VER: ViewVersionMode,
    MAIN_MODE.QUERY: QueryMode,
    MAIN_MODE.SHOW_VPD: ShowVpdMode,
    MAIN_MODE.IMAGE: ImageGenerateMode
}


def main(*argv):
    mode = None
    try:
        argParser = MlxBurn_ArgumentParser()
        args = argParser.parse_args(argv)

        init_logging(args)

        mode = MAIN_MODE_OBJECTS[args.main_mode](args)
        ret = mode.execute()
        if args.main_mode == MAIN_MODE.IMAGE and args.mst_dev:
            burn_mode = BurnMode(args, ret)
            burn_mode.execute()
    except KeyboardInterrupt as k:
        exit(k)
    except BaseException:
        raise
    finally:
        del mode
    return 0


if __name__ == "__main__":
    try:
        sys.exit(main(*sys.argv[1:]))
    except Exception as e:
        sys.exit(e.args[1])
