import argparse
import logging
from cli_wrapping_utils import *
from mlxburn_constants import BURN_PROGRAM
from modes.mlxburn_mode import I_MlxburnMode
from mlxburn_utils import execute_check


class BurnMode(I_MlxburnMode):
    def __init__(self, args: argparse.Namespace, bin_file: Path):
        super().__init__(args)
        self._bin_file = bin_file

    def execute(self):
        burn_cmd = self.prepare_burn_command()
        logging.debug("running {}".format((burn_cmd)))
        execute_check(burn_cmd, "Image burn failed: {rc}", None)

        logging.info("Image burn completed successfully.")

    def prepare_burn_command(self):
        cmd_gen = CmdGenerator(BURN_PROGRAM)
        I_OptArgGenerator.set_option_prefix("--")

        cmd_gen.add_argument(inputArgPipeOAG("device", self._args.mst_dev))
        if self._args.nofs:
            cmd_gen.add_argument(addFlagOAG("nofs"))
        cmd_gen.add_argument(inputArgPipeOAG("image", self._bin_file))
        if self._args.force:
            cmd_gen.add_argument(addFlagOAG("yes"))
        if self._args.quick_query:
            cmd_gen.add_argument(addFlagOAG("qq"))
        cmd_gen.add_argument(inputArgPipeOAG("i2c_secondary", self._args.i2c_secondary))
        additional = self._args.additional_burn_query_args + self._args.additional_burn_args + self._args.additional_common_args
        cmd_gen.add_argument(extensionPositionalOAG(*additional))
        cmd_gen.add_argument(addPositionalFlagOAG("burn"))
        cmd_gen.add_argument(inputArgPipeOAG("vsd", self._args.vsd))

        return cmd_gen.get_cmd()
