# Copyright (C) Nov 2020 Mellanox Technologies Ltd. All rights reserved.
# Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# This software is available to you under a choice of one of two
# licenses.  You may choose to be licensed under the terms of the GNU
# General Public License (GPL) Version 2, available from the file
# COPYING in the main directory of this source tree, or the
# OpenIB.org BSD license below:
#
#     Redistribution and use in source and binary forms, with or
#     without modification, are permitted provided that the following
#     conditions are met:
#
#      - Redistributions of source code must retain the above
#        copyright notice, this list of conditions and the following
#        disclaimer.
#
#      - Redistributions in binary form must reproduce the above
#        copyright notice, this list of conditions and the following
#        disclaimer in the documentation and/or other materials
#        provided with the distribution.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.
# --

import ctypes
from collections import namedtuple


__all__ = ['ICMAddress', 'MSTDeviceInfo', 'icm_obj_addr', 'packet_attr',
           'steering_crawler', 'steering_crawler_attr']


################################################################################
# Python types
################################################################################
ICMAddress = namedtuple('ICMAddress', ['seg_type', 'gvmi', 'index'])
MSTDeviceInfo = namedtuple('MSTDeviceInfo', ['name', 'hw_dev_id', 'type'])


################################################################################
# C types
################################################################################
class steering_crawler(ctypes.Structure):
    pass


class steering_crawler_attr(ctypes.Structure):
    _fields_ = [('verbosity_level', ctypes.c_int)]


class egress(ctypes.Structure):
    _fields_ = [('src_gvmi', ctypes.c_uint32),
                ('reg_a_value', ctypes.c_uint32),
                ('qpn', ctypes.c_uint32),
                ('qp_flags', ctypes.c_uint32)]


class ingress(ctypes.Structure):
    pass


class packet_src(ctypes.Union):
    _fields_ = [('ingress', ingress),
                ('egress', egress)]


class packet_attr(ctypes.Structure):
    _fields_ = [('packet_buf', ctypes.POINTER(ctypes.c_char)),
                ('packet_len', ctypes.c_uint32),
                ('flags', ctypes.c_uint32),
                ('vhca_port_num', ctypes.c_uint8),
                ('packet_src', packet_src)]


class icm_obj_addr(ctypes.Structure):
    _fields_ = [('seg_type', ctypes.c_uint16),
                ('gvmi', ctypes.c_uint16),
                ('index', ctypes.c_uint64)]
