#
# Copyright (c) 2006-2007 Cisco Systems, Inc.  All rights reserved.
#

#############################################################################
#
# Configuration Options
#
#############################################################################

# Help for OFED RPMs

%{!?ofed: %define ofed 0}

# Should we build a debuginfo RPM or not?
# type: bool (0/1)
%{!?build_debuginfo_rpm: %define build_debuginfo_rpm 0}

# Should we leave the BUILD_ROOT around?  Default: no
# type: bool (0/1)
%{!?leave_build_root: %define leave_build_root 0}

# Should we use the default "check_files" RPM step (i.e., check for
# unpackaged files)?  It is discouraged to disable this, but some
# installers need it (e.g., OFED, because it installs lots of other
# stuff in the BUILD_ROOT before Open MPI).
# type: bool (0/1)
%{!?use_check_files: %define use_check_files 1}

# Should we use the traditional % build and % install sections?  Or
# should we combine them both into % install?  This is entirely
# motivated by the OFED installer where, on SLES, the % build macro
# will completely remove the BUILD_ROOT before building (which breaks
# some assumptions in the OFED installer).  Ick!
# type: bool (0/1)
%{!?munge_build_into_install: %define munge_build_into_install 0}

# Where should the shell script startup files go?  The default is to
# put them in the package data directory.
# type: string (location of shell startup file directory)
%{!?shell_startup_dir: %define shell_startup_dir %{_datadir}/%{name}}


#############################################################################
#
# OFED-specific defaults
#
# Tailored for the peculiar requirements of the OFED installer; not
# necessary for when building this SRPM outside of the OFED installer.
#
#############################################################################

%if %{ofed}
%define leave_build_root 1
%define use_check_files 0
%define munge_build_into_install 1
%define shell_startup_dir /etc/profile.d
%endif


#############################################################################
#
# Configuration Logic
#
#############################################################################

%if !%{build_debuginfo_rpm}
%define debug_package %{nil}
%endif

%if !%{use_check_files}
%define __check_files %{nil}
%endif

%{!?configure_options: %define configure_options %{nil}}


#############################################################################
#
# Preamble Section
#
#############################################################################

Summary: A simple tool to provide site-wide and per-user defaults for which MPI implementation to use
Name: %{?_name:%{_name}}%{!?_name:mpi-selector}
Version: 1.0.3
Release: 1.54375
License: BSD
Group: Applications/System
Source: mpi-selector-%{version}.tar.gz
Packager: %{?_packager:%{_packager}}%{!?_packager:%{_vendor}}
Vendor: %{?_vendorinfo:%{_vendorinfo}}%{!?_vendorinfo:%{_vendor}}
Distribution: %{?_distribution:%{_distribution}}%{!?_distribution:%{_vendor}}
Prefix: %{_prefix}
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

%description
A simple tool that allows system administrators to set a site-wide
default for which MPI implementation is to be used, but also allow
users to set their own defaults MPI implementation, thereby overriding
the site-wide default.

The default can be changed easily via the mpi-selector command --
editing of shell startup files is not required.

#############################################################################
#
# Prepatory Section
#
#############################################################################
%prep
# Unbelievably, some versions of RPM do not first delete the previous
# installation root (e.g., it may have been left over from a prior
# failed build).  This can lead to Badness later if there's files in
# there that are not meant to be packaged.  HOWEVER: in some cases, we
# do not want to delete the prior RPM_BUILD_ROOT because there may be
# other stuff in there that we need (e.g., the OFED installer installs
# everything into RPM_BUILD_ROOT that OMPI needs to compile, like the
# OpenFabrics drivers).
%if !%{leave_build_root}
rm -rf $RPM_BUILD_ROOT
%endif

%setup -q -n %{name}-%{version}

#############################################################################
#
# Build Section
#
#############################################################################

# See note above about %{munge_build_into_install}
%if %{munge_build_into_install}
%install
%else
%build
%endif

# There's very little to do in this section: configure and make
%configure %{configure_options} --with-shell-startup-dir=%{shell_startup_dir}
%{__make}


#############################################################################
#
# Install Section
#
#############################################################################

# See note above about %{munge_build_into_install}
%if !%{munge_build_into_install}
%install
%endif
%{__make} install DESTDIR=$RPM_BUILD_ROOT

# If there's an old site-wide default file, rename it
if test -f %{_sysconf}/mpi-selector; then
    mv -f %{_sysconf}/mpi-selector %{_sysconf}mpi-selector.rpmorig
fi

#############################################################################
#
# Clean Section
#
#############################################################################
%clean
cd /
# Remove installed driver after rpm build finished
rm -rf $RPM_BUILD_DIR/%{name}-%{version} 

# Leave $RPM_BUILD_ROOT in order to build dependent packages, if desired
%if !%{leave_build_root}
test "x$RPM_BUILD_ROOT" != "x" && rm -rf $RPM_BUILD_ROOT
%endif


#############################################################################
#
# Files Section
#
#############################################################################

%files
%defattr(-, root, root, -)
%doc README LICENSE
%{_bindir}/mpi-selector
%{_bindir}/mpi-selector-menu
%{_mandir}/man1/mpi-selector.*
%{_mandir}/man1/mpi-selector-menu.*
%{shell_startup_dir}/mpi-selector.sh
%{shell_startup_dir}/mpi-selector.csh


#############################################################################
#
# Changelog
#
#############################################################################
%changelog
* Wed Feb 14 2007 Jeff Squyres <jsquyres@cisco.com>
- First version
