# Congestion Control (Version: OpenSM 5.7.0)

Copyright (c) 2021 NVIDIA CORPORATION & AFFILIATES. All rights reserved.  

OpenSM version of congestion control is used to prevent congestion in the fabric.


## OpenSM configuraiton

### Enabling Congestion Control
In order to enable congestion control, set the parameter *mlnx_congestion_control*
in OpenSM configuration file to *2*
For example:
```
mlnx_congestion_control 2
```
To disable congestion control, set parameter value to *1*
For example:
```
mlnx_congestion_control 1
```


### Defining a Congestion Control Policy File
To define a congestion control policy file, set the parameter
*congestion_control_file* in OpenSM configuration file to point to congestion control policy file.
For example:
```
congestion_control_policy_file /etc/opensm/conf/congestion_control_policy_file
````


## Congestion Control Policy File

The Policy file is composed of configuration blocks that in total define the CC configuration in the fabric.

Policy file configuration blocks are:
+ ca_config - CA/end-ports configuration
+ switch_config - Switch configuration
+ profiles - Triplet of congestion control profiles, contain a list of three *profile* blocks
+ profile - Sub-block of *profiles*, single switch congestion control profile
+ sl_config - Mapping from SL to profile index (within a triplet)
+ vl_config - Mapping from VL to profiles

Each block should start with its block's name concatenated with '_start'
and should end with the block's name concatenated with '_end'.
For example, *ca_config* block should be defined as follows:
```
ca_config_start
    ...
ca_config_end
```

To set block's field value, specify field name and field value separated by a colon ':'. For example:
```
ca_config_start
    group: ALL_CAS
    enable_notify: 1
    ...
ca_config_end
```

When there are contradictions in the configuration file, OpenSM gives precedence for the first defined configuration in the file.
Additional entries of the same fields, or configurations that contradicts preceding configurations are ignored.


### CA Configuration (ca_config)
Set CAs Congestion Control parameters according to PRM.
All fields are mandatory.
*group* field defines which CAs are configured by the block.
Note: currently supports only *ALL_CAS* tag.
```
ca_config_start
	group: ALL_CAS
	enable_notify: 1
	enable_react: 1
	enable_clamp_tgt_rate: 1
	enable_clamp_tgt_rate_after_time_inc: 1
	rpg_time_reset: 328
	rpg_byte_reset: 184320
	rpg_threshold: 5
	rpg_max_rate: 0
	rpg_ai_rate: 9
	rpg_hai_rate: 69
	rpg_gd: 12
	rpg_min_dec_fac: 50
	rpg_min_rate: 1
	rate_to_set_on_first_cnp: 122880
	dce_tcp_g: 1023
	dce_tcp_rtt: 5
	rate_reduce_monitor_period: 2
	initial_alpha_value: 26
	min_time_between_cnps: 3
#   cnp_sl_mode 0: Take SL from the received packet, 1: Determine the SL number by cnp_sl.
	cnp_sl_mode: 0
	cnp_sl: 1
ca_config_end
```


### Switch configuration (switch_config)
Set switch configuration according to PRM.
*group* field defines which switches are configured by the block.
Note: currently supports only *ALL_SWITCHES* tag.

Foe example:
```
switch_config_start
	group: ALL_SWITCHES
	enable: 1
	aqs_weight: 4
	aqs_time: 10
switch_config_end
```


### Profile block
Profile block can be defined only inside *profiles* block (see below).
Set single profile configuration according to PRM.


### Profiles block
Contains triplets of profile (three consecutive of *profile* block).
Profiles block is used to map VL to profile triplets by *vl_config* blocks.
Fields:
+ name - Name of triplet, must be unique.
+ mode - Controls the mode of all the profiles (fixed/percent).

Must contain three consecutive *profile* block.
For exmaple:

```
profiles_start
	name: Profiles1
	mode: 0
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
profiles_end
```


### VL configuration (vl_config)
Map VL to profile triplets.
Fields:
+ group - Defines on what switch ports to apply this configuration.
	Note: Currently supports only the 'SWITCH_PORTS' tag. (All the ports)
+ vl_profiles: Comma separated list of 1 or 15 profiles triplet names, where the first element represent the profiles triplet mapped to VL0, and the last element represents the profiles triple mapped to VL14.
    If only one element is specified, all these VLs will be mapped to the specified profiles triplet.

Example for the same profiles triplet configured for all the VLs:
```
vl_config_start
	group: SWITCH_PORTS
	vl_profiles: Profiles1
vl_config_end
```

Example for the different profiles triplets configured for the Vls:
```
vl_config_start
	group: SWITCH_PORTS
	vl_profiles: P1,P2,P1,P2,P1,P2,P1,P2,P1,P2,P1,P2,P1,P2,P1,P2
vl_config_end
```


### SL configuration (sl_config)
MAP SL to profile index.
Fields:
+ group - Defines on what switch ports to apply this configuration.
	Note: Currently supports only the 'SWITCH_PORTS' tag. (All the ports)
+ sl_profiles: Comma separated list of 1 or 16 profile indexes (values between 1 and 3), where the first element represent the profile index to be mapped to SL0, and the last element represents the profile index mapped to SL15.
    Set 0 to turn off congestion control on a particular sl.
    If only one element is specified, all SLs will be mapped to the specified profile index.

Example for the same profile (1) index configured for all the SLs:
```
sl_config_start
	group: SWITCH_PORTS
	sl_profiles: 1
sl_config_end
```

Example for different profile indexes configured for different SLs:
```
sl_config_start
	group: SWITCH_PORTS
	sl_profiles: 1,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3
sl_config_end
```

Example of Congestion Control disabled on SL2:
```
sl_config_start
	group: SWITCH_PORTS
	sl_profiles: 1,2,0,2,2,3,3,3,3,3,3,3,3,3,3,3
sl_config_end
```

## Example of a congestion control policy file:

```
ca_config_start
	group: ALL_CAS
	enable_notify: 1
	enable_react: 1
	enable_clamp_tgt_rate: 1
	enable_clamp_tgt_rate_after_time_inc: 1
	rpg_time_reset: 328
	rpg_byte_reset: 184320
	rpg_threshold: 5
	rpg_max_rate: 0
	rpg_ai_rate: 9
	rpg_hai_rate: 69
	rpg_gd: 12
	rpg_min_dec_fac: 50
	rpg_min_rate: 1
	rate_to_set_on_first_cnp: 122880
	dce_tcp_g: 1023
	dce_tcp_rtt: 5
	rate_reduce_monitor_period: 2
	initial_alpha_value: 26
	min_time_between_cnps: 3
	# cnp_sl_mode - 0: Take SL from the received packet, 1: Determine the SL number by cnp_sl.
	cnp_sl_mode: 0
	cnp_sl: 1
ca_config_end


switch_config_start
	group: ALL_SWITCHES
	enable: 1
	aqs_weight: 4
	aqs_time: 10
switch_config_end


# 3 in each set
profiles_start
	name: Profiles1
	mode: 0
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
	profile_start
		percent: 52
		min: 51200
		max: 839680
	profile_end
profiles_end


sl_config_start
	group: SWITCH_PORTS
	# Map SL to profile number, set profile to 0 in order to disable congestion control on a particular SL.
	sl_profiles: 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
sl_config_end


vl_config_start
    group: SWITCH_PORTS
    vl_profiles: Profiles1
vl_config_end
```
